/**
 *
 *   Universite catholique de Louvain
 *   CEREM : Centre for research in mechatronics
 *   http://www.robotran.be
 *   Contact : info@robotran.be
 *
 *
 *   MBsysC main script template for simplemat---------
 *    This template loads the data file *.mbs and execute:
 *      - the coordinate partitioning module
 *      - the direct dynamic module (time integration of
 *        equations of motion).
 *    It may be adapted and completed by the user.
 *
 *    (c) Universite catholique de Louvain
 *
 * To turn this file as a C++ file, just change its extension to .cc (or .cpp).
 * If you plan to use some C++ files, it is usually better that the main is compiled as a C++ function.
 * Currently, most compilers do not require this, but it is a safer approach to port your code to other computers.
 */

#include <stdio.h>
#include "mbs_data.h"
#include "mbs_invdyn.h"
#include "mbs_part.h"
#include "mbs_set.h"
#include "mbs_solvekin.h"
#include "mbs_loader.h"
#include "user_all_id.h"
#include "user_model.h"
#include "useful_functions.h"

int main(int argc, char const *argv[])
{
    printf("Starting delta_fisette_c MBS project!\n");

    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    /*                     LOADING                               *
    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
    MbsData *mbs_data, *closed_mbs_data;

    printf("Loading the DeltaRobot data file !\n");
    mbs_data = mbs_load("delta_fisette_c.mbs"); 
    printf("*.mbs file loaded!\n");

    // Set the user constraints number
    mbs_set_nb_userc(mbs_data, 3);

    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    /*              COORDINATE PARTITIONING                      *
    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
    MbsPart *mbs_part;
    mbs_data->process = 1;

    // Set the platform variables as independant
    mbs_set_qu(mbs_data, TxPlatform_id);
    mbs_set_qu(mbs_data, TyPlatform_id);
    mbs_set_qu(mbs_data, TzPlatform_id);

    mbs_part = mbs_new_part(mbs_data);

    mbs_part->options->rowperm = 1;
    mbs_part->options->verbose = 2;

    mbs_run_part(mbs_part, mbs_data);

    mbs_delete_part(mbs_part);


    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    /*                   INVERSE KINEMATICS                      *
    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
    MbsSolvekin *mbs_solvekin;
    mbs_data->process = 5;

    // Set the platform variables as driven
    mbs_set_qdriven(mbs_data, TxPlatform_id);
    mbs_set_qdriven(mbs_data, TyPlatform_id);
    mbs_set_qdriven(mbs_data, TzPlatform_id);

    mbs_solvekin = mbs_new_solvekin(mbs_data);

    // solvekin options, to interpolate part of the previous motion
    mbs_solvekin->options->t0 = 0.0;
    mbs_solvekin->options->tf = 5.0;
    mbs_solvekin->options->dt = 1e-2;
    mbs_solvekin->options->framerate = 100;
    mbs_solvekin->options->verbose = 1;
    mbs_solvekin->options->motion = trajectory; 
    //If no independant joints are found, no trajectory files are needed. The driven joints will be imposed (see user_DrivenJoitns.c)
    
    mbs_run_solvekin(mbs_solvekin, mbs_data);

    mbs_delete_solvekin(mbs_solvekin, mbs_data);

    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    /*                     INVERSE DYNANMICS                     *
    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
    MbsInvdyn *mbs_invdyn;
    mbs_data->process = 6;

    // 1 = with joint viscous friction, 0 = without joint friction
    mbs_data->user_model->friction.flag = 1; 

    // Set the actuated variables as independent
    mbs_set_qu(mbs_data, actLeg1_id);
    mbs_set_qu(mbs_data, actLeg2_id);
    mbs_set_qu(mbs_data, actLeg3_id);

    // Set the platform variable as dependent
    mbs_set_qv(mbs_data, TxPlatform_id);
    mbs_set_qv(mbs_data, TyPlatform_id);
    mbs_set_qv(mbs_data, TzPlatform_id);

    //  Set the actuated variables as independent (already done in MBsysPad)
     //mbs_set_qa(mbs_data, actLeg1_id);
     //mbs_set_qa(mbs_data, actLeg2_id);
     //mbs_set_qa(mbs_data, actLeg3_id);

    mbs_invdyn = mbs_new_invdyn(mbs_data);
    
    // mbs_invdyn options (see documentations for additional options)
    mbs_invdyn->options->motion = trajectory;
    mbs_invdyn->options->trajectoryqname = "../../resultsR/solvekin_q.res";
    mbs_invdyn->options->trajectoryqdname = "../../resultsR/solvekin_qd.res";
    mbs_invdyn->options->trajectoryqddname = "../../resultsR/solvekin_qdd.res";

    // inverse dynamics : on the basis of the trajectory stored after solvekin in *.res
    mbs_run_invdyn(mbs_invdyn, mbs_data);

    mbs_delete_invdyn(mbs_invdyn, mbs_data);

    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    /*                   CLOSING OPERATIONS                      *
    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
    mbs_delete_data(mbs_data);

    return 0;
}

